unit SKeveresU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    btmKeverHalmaz: TButton;
    btmKilep: TButton;
    btnRendezes: TButton;
    btnKeverTomb: TButton;
    procedure btmKeverHalmazClick(Sender: TObject);
    procedure btnRendezesClick(Sender: TObject);
    procedure btnKeverTombClick(Sender: TObject);
    procedure btmKilepClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// A Memo1 elemeinek keverse halmaz segtsgvel
procedure TForm1.btmKeverHalmazClick(Sender: TObject);
var
  jelzo : set of byte;
  i, a, b, db : integer;
begin
  db:=Memo1.Lines.count;
  if db>256 then
     begin
        ShowMessage('Tl sok elem, halmazzal nem keverhet ssze.');
        exit;
     end;
  jelzo:=[];
  // A jelzhalmaz feltltse a lehetsges indexekkel
  for i:=0 to db-1 do
    include(Jelzo,i);
  // Mindegyik elemet felcserlnk egy
  // vletlenpozcin elhelyezkedvel
  for a:=0 to db-1 do
   begin
      repeat
        b:=Random(db);
      until (b in jelzo) or (jelzo=[]);
      exclude(jelzo,b);
      Memo1.Lines.Exchange(a,b);
   end;
end;


// A Memo1 elemeinek keverse dinamikus tmb segtsgvel
procedure TForm1.btnKeverTombClick(Sender: TObject);
var
  jelzo : array of boolean;
  i, a, b, db, cnt : integer;
begin
  db:=Memo1.Lines.count;
  SetLength(jelzo,db);
  // A jelztmb feltltse true rtkkel
  for i:=0 to db-1 do
    Jelzo[i]:=true;
  // Mindegyik elemet felcserlnk egy
  // vletlenpozcin elhelyezkedvel
  cnt:=0;
  for a:=0 to db-1 do
   begin
      repeat
        b:=Random(db);
      until Jelzo[b] or (cnt=db);
      Jelzo[b]:=false;
      inc(cnt);
      Memo1.Lines.Exchange(a,b);
   end;
end;

// A sorok rendezesehez TStringList objektumot hasznalunk
procedure TForm1.btnRendezesClick(Sender: TObject);
var
  sl : TStringList;
begin
   sl:=TStringList.Create;
   sl.Text:=Memo1.Lines.Text;
   sl.Sort;
   Memo1.Lines.Text:=sl.Text;
   sl.free;
end;


procedure TForm1.btmKilepClick(Sender: TObject);
begin
  Form1.Close;
end;

end.
